# Version 2.8 - 2.9

## Config changes

The google product feed config settings have been updated so that they are nested instead of all being prefixed with "googleFeed". If the plugin config has been extended and the google feed config settings added then the config will need to be updated from the old format:

```
googleFeedCategory => null,
googleFeedUseFile => false,
googleFeedFilepath => 'webroot/product_feed.xml',
```

to the new format:

```
'googleFeed' => [
	'useFile' => false, //Whether to use a generate feed file instead of generating a feed for each request.
	'filepath' => 'webroot/product_feed.xml', //The filepath to the generated feed file.
	'brand' => null, //The fallback brand to use on products when no brand is set.
	'category' => null, //The fallback category to use on products when no category is set.
],
```

If any of these config settings have been used outside of the plugin then they will also need to be updated to use the new config paths:

* `EvShop.googleFeedCategory` will need to become `EvShop.googleFeed.category`
* `EvShop.googleFeedUseFile` will need to become `EvShop.googleFeed.useFile`
* `EvShop.googleFeedFilepath` will need to become `EvShop.googleFeed.filepath`

## Method changes

The method `_getVariantId` in the `GoogleFeedLib` has had the method name changed to `_getAttributeVariantId` to better reflect it's purpose as it returns the id attribute for the feed and will differ from the actual id of the variant that is being added. If the library has been extended and this method used then this will need to be updated.
